class ulamek
    {
    private:
    	int licznik, mianownik;
    public:
    	ulamek(int alicznik=0,int amianownik=1)
            {
            set(alicznik,amianownik);
            }
    	ulamek(const ulamek& aulamek)
            {
            aulamek.get(licznik,mianownik);
            }
    	void set(int alicznik,int amianownik)
            {
            if (amianownik==0) throw "Ulamek: Blad #1";
            licznik=alicznik;
            mianownik=amianownik;
            }
        void get(int& rlicznik,int& rmianownik) const
            {
            rlicznik=licznik;
            rmianownik=mianownik;
            }
        void get(int* plicznik,int* pmianownik) const
            {
            *plicznik=licznik;
            *pmianownik=mianownik;
            }
    };

const ulamek ulamek_zero(0,1);
const ulamek ulamek_jeden(1,1);
const ulamek ulamek_polowa(1,2);
const ulamek ulamek_cwierc(1,4);

ulamek operator *(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek(alicznik1*alicznik2,amianownik1*amianownik2);
    };
ulamek operator /(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek(alicznik1*amianownik2,amianownik1*alicznik2);
    };
ulamek operator +(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek(alicznik1*amianownik2+alicznik2*amianownik1,amianownik1*amianownik2);
    };
ulamek operator -(const ulamek& aulamek1)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    return ulamek(-alicznik1,amianownik1);
    };
ulamek operator -(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek(alicznik1*amianownik2-alicznik2*amianownik1,amianownik1*amianownik2);
    };
bool operator <(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)<(alicznik2/(double)amianownik2);
    };
bool operator >(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)>(alicznik2/(double)amianownik2);
    };
bool operator ==(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)==(alicznik2/(double)amianownik2);
    };

